/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.standard.v2_1;

import com.roguewave.chart.core.v2_1.ChartBuilder;
import com.roguewave.chart.core.v2_1.ChartGraphics;
import com.roguewave.chart.core.v2_1.ChartPart;
import com.roguewave.chart.core.v2_1.ChartProperties;
import com.roguewave.chart.core.v2_1.Customizer;
import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.core.v2_1.graphics.ColorArray;
import com.roguewave.chart.core.v2_1.graphics.Drawable;
import com.roguewave.chart.core.v2_1.graphics.Point3D;
import com.roguewave.chart.core.v2_1.graphics.SortTreeInternal;
import com.roguewave.chart.core.v2_1.graphics.SortTreeLeaf;
import com.roguewave.chart.core.v2_1.graphics.SortTreeNode;
import com.roguewave.chart.core.v2_1.graphics.StandardColors;
import com.roguewave.chart.core.v2_1.graphics.Transform3D;
import com.roguewave.chart.standard.v2_1.parts.BinScale;
import com.roguewave.chart.standard.v2_1.parts.NumericGrid;
import com.roguewave.chart.standard.v2_1.parts.NumericScale;
import com.roguewave.chart.standard.v2_1.parts.Platform;
import com.roguewave.chart.standard.v2_1.parts.RescalerDrawable;
import com.roguewave.chart.standard.v2_1.parts.Spacer;
import java.awt.Font;

public abstract class LineAreaChartBase
implements ChartBuilder {
    private static final double defaultDepth = 0.8;
    private static final double defaultBasePad = 0.25;
    private static final double defaultBaseHeight = 0.5;

    protected abstract ChartPart makeRow(ChartProperties var1, DataModel var2, int var3, Transform3D var4, ColorArray var5);

    protected abstract int chartRows(int var1);

    public boolean supports(int viewMode) {
        switch (viewMode) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public ChartGraphics build(ChartProperties properties, DataModel data) {
        Point3D[] testPoints;
        double basePad = properties.getProperty("BasePad", 0.25);
        double baseHeight = properties.getProperty("PlatformHeight", 0.5);
        double depth = properties.getProperty("PartDepth", 0.8);
        ChartGraphics chartGraphics = new ChartGraphics();
        Customizer customizer = properties.get2DStyleCustomizer();
        if (customizer != null) {
            chartGraphics.add2DDrawable(customizer.getDrawable(properties, data));
        }
        if ((customizer = properties.get3DStyleCustomizer()) != null) {
            chartGraphics.add3DDrawable(customizer.getDrawable(properties, data));
        }
        int rows = data.getRowCount();
        int columns = data.getColumnCount();
        int numRows = this.chartRows(rows);
        ChartPart[] parts = new ChartPart[numRows];
        chartGraphics.setParts(parts);
        double baseDepth = (double)numRows + (double)2 * basePad;
        double baseFrontZ = -baseDepth / 2.0;
        double baseBackZ = baseDepth / 2.0;
        double rowZ = baseFrontZ + basePad;
        StandardColors colors = new StandardColors();
        if (numRows == 1 && rows > 1) {
            parts[0] = this.makeRow(properties, data, 0, Transform3D.translate(0.0, 0.0, rowZ), colors);
        } else {
            for (int row = 0; row < numRows; ++row) {
                parts[row] = this.makeRow(properties, data, row, Transform3D.translate(0.0, 0.0, rowZ), colors);
                rowZ += 1.0;
            }
        }
        boolean isMultiRow = numRows != 1;
        Customizer platform = new Platform(isMultiRow);
        platform = (Customizer)properties.getProperty("3DPlatform", platform);
        Drawable platformDrawable = platform.getDrawable(properties, data);
        SortTreeLeaf stlPlatform = new SortTreeLeaf();
        stlPlatform.addDrawable(platformDrawable);
        BinScale binScale = new BinScale(columns, 0.0, true, true, false);
        Drawable bscale = binScale.getDrawable(properties, data);
        double scaleHeight = binScale.getScalableHeight();
        chartGraphics.add2DDrawable(bscale);
        double scaleIncrement = 10.0;
        double range = properties.getDataRangeHigh() - properties.getDataRangeLow();
        while (range / scaleIncrement > (double)10) {
            scaleIncrement *= (double)10;
        }
        while (range / scaleIncrement < (double)5) {
            scaleIncrement /= (double)2;
        }
        scaleIncrement = properties.getProperty("ScaleIncrement", scaleIncrement);
        double lowLine = (double)((int)(properties.getDataRangeLow() / scaleIncrement)) * scaleIncrement;
        if (properties.scaleY(lowLine) < 0.0) {
            lowLine += scaleIncrement;
        }
        Spacer spacer = new Spacer(properties, lowLine, scaleIncrement);
        SortTreeLeaf backDropNode = new SortTreeLeaf();
        Transform3D trans = Transform3D.translate(0.0, 0.0, baseBackZ);
        NumericGrid numericGrid = new NumericGrid(lowLine, scaleIncrement, trans);
        Drawable grid = numericGrid.getDrawable(properties, data);
        backDropNode.addDrawable(grid);
        chartGraphics.add2DDrawable(grid);
        double halfWidth = (double)columns / 2.0;
        int rightScaleAlignment = 2;
        Point3D lowRight = new Point3D(halfWidth, 0.0, baseBackZ);
        double z = baseBackZ;
        Customizer scale = new NumericScale(columns, lowLine, scaleIncrement, z, true, true);
        scale = (Customizer)properties.getProperty("3DRightScale", scale);
        if (scale != null) {
            backDropNode.addDrawable(scale.getDrawable(properties, data));
        }
        if ((scale = (Customizer)properties.getProperty("3DLeftScale", null)) != null) {
            backDropNode.addDrawable(scale.getDrawable(properties, data));
        }
        scale = new NumericScale(columns, lowLine, scaleIncrement, true);
        scale = (Customizer)properties.getProperty("2DLeftScale", scale);
        chartGraphics.add2DDrawable(scale.getDrawable(properties, data));
        double scaleWidth = 0.5;
        NumericScale leftScale = null;
        if (scale instanceof NumericScale) {
            leftScale = (NumericScale)scale;
            scaleWidth = 0.0;
        }
        rowZ = baseFrontZ + basePad + 1.0;
        SortTreeNode lineRows = parts[0].getSortTree();
        for (int i = 1; i < numRows; ++i) {
            testPoints = new Point3D[]{new Point3D(0.0, 0.0, rowZ), new Point3D(0.0, 1.0, rowZ), new Point3D(1.0, 0.0, rowZ)};
            lineRows = new SortTreeInternal(lineRows, parts[i].getSortTree(), testPoints);
            rowZ += 1.0;
        }
        testPoints = new Point3D[]{new Point3D(0.0, 0.0, 0.0), new Point3D(1.0, 0.0, 0.0), new Point3D(0.0, 0.0, 1.0)};
        SortTreeInternal stn = new SortTreeInternal(stlPlatform, lineRows, testPoints);
        testPoints = new Point3D[]{new Point3D(0.0, 0.0, baseBackZ), new Point3D(0.0, 1.0, baseBackZ), new Point3D(1.0, 0.0, baseBackZ)};
        chartGraphics.setSortTree(new SortTreeInternal(stn, backDropNode, testPoints));
        chartGraphics.setBounds3D(this.get3DBoundingBox(properties, data, spacer));
        Point3D[] bounds = this.get2DBoundingBox(properties, data, spacer, scaleWidth, scaleHeight);
        chartGraphics.setBounds2D(bounds);
        if (leftScale != null) {
            String[] leftScaleStrings = leftScale.getStrings();
            Font leftScaleFont = leftScale.getFont();
            chartGraphics.setRescaler(new RescalerDrawable(leftScaleStrings, leftScaleFont, bounds));
        } else {
            Font bottomScaleFont = binScale.getFont();
            chartGraphics.setRescaler(new RescalerDrawable(bottomScaleFont, bounds));
        }
        return chartGraphics;
    }

    public Point3D[] get3DBoundingBox(ChartProperties properties, DataModel data, Spacer spacer) {
        int rows = data.getRowCount();
        int columns = data.getColumnCount();
        double basePad = properties.getProperty("BasePad", 0.25);
        double baseHeight = properties.getProperty("PlatformHeight", 0.5);
        double baseDepth = (double)this.chartRows(rows) + (double)2 * basePad;
        double baseFrontZ = -baseDepth / 2.0;
        double baseBackZ = baseDepth / 2.0;
        int numIncrements = spacer.valueCount();
        double gridMax = properties.scaleY(spacer.getValue(numIncrements - 1));
        double scaleWidth = 1.0;
        double left = (double)(-columns) / 2.0;
        double right = (double)columns / 2.0;
        double bottom = -baseHeight;
        double top = properties.getChartHeight();
        if (gridMax > top) {
            top = gridMax;
        }
        double front = baseFrontZ;
        double back = baseBackZ;
        Point3D[] points = new Point3D[]{new Point3D(left, bottom, front), new Point3D(left, bottom, back), new Point3D(left, top += 0.2, back), new Point3D(left, top, front), new Point3D(right, bottom, front), new Point3D(right + scaleWidth, bottom, back), new Point3D(right + scaleWidth, top, back), new Point3D(right, top, front)};
        return points;
    }

    Point3D[] get2DBoundingBox(ChartProperties properties, DataModel data, Spacer spacer, double scaleWidth, double scaleHeight) {
        int rows = data.getRowCount();
        int columns = data.getColumnCount();
        double left = (double)(-columns) / 2.0 - scaleWidth;
        double right = (double)columns / 2.0;
        double bottom = -scaleHeight;
        double top = properties.getChartHeight();
        int numIncrements = spacer.valueCount();
        double gridMax = properties.scaleY(spacer.getValue(numIncrements - 1));
        if (gridMax > top) {
            top = gridMax;
        }
        Point3D[] points = new Point3D[]{new Point3D(left, bottom, 0.0), new Point3D(left, top, 0.0), new Point3D(right, bottom, 0.0), new Point3D(right, top, 0.0)};
        return points;
    }
}

